.\" Copyright (c) 1995  Hewlett-Packard Company
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the Hewlett-Packard Company shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" Hewlett-Packard Company.
.\"
.TH XdbeAllocateBackBufferName __libmansuffix__ 1996-03-11 __xorgversion__
.SH NAME
XdbeAllocateBackBufferName - allocates a DBE buffer.
.SH SYNOPSIS
\&#include <X11/extensions/Xdbe.h>
.sp
.nf
XdbeBackBuffer XdbeAllocateBackBufferName(
    Display        *dpy,
    Window         window,
    XdbeSwapAction swap_action)
.fi
.SH DESCRIPTION
This function returns a drawable ID used to refer to the back buffer of the
specified window.
The
.I swap_action
is a hint to indicate the swap action that
will likely be used in subsequent calls to
.BR XdbeSwapBuffers (__libmansuffix__).
The actual swap action used in calls to
.BR XdbeSwapBuffers (__libmansuffix__)
does not have to be the same as the
.I swap_action
passed to this function, though clients are encouraged to provide
accurate information whenever possible.
.SH ERRORS
.IP BadAlloc
.IP BadIDChoice
.IP BadMatch
The specified window is not an InputOutput window or its visual does not
support DBE.
.IP BadValue
An invalid swap action was specified.
.IP BadWindow
An invalid window was specified.
.SH SEE ALSO
.BR DBE (__libmansuffix__),
.BR XdbeBeginIdiom (__libmansuffix__),
.BR XdbeDeallocateBackBufferName (__libmansuffix__),
.BR XdbeEndIdiom (__libmansuffix__),
.BR XdbeFreeVisualInfo (__libmansuffix__),
.BR XdbeGetBackBufferAttributes (__libmansuffix__),
.BR XdbeGetVisualInfo (__libmansuffix__),
.BR XdbeQueryExtension (__libmansuffix__),
.BR XdbeSwapBuffers (__libmansuffix__).
